function [a]=sens_plot5(skt,dsr,n,nds);
%function [a]=sens_plot5(skt,dsr,n,nds);
% Ian Stothers oct 2018

  if (nargin<4)  dsr=100;   end
  if (nargin<3)  n=10000;   end
  if (nargin<2)  nds=1000;  end
  if (nargin<1)  skt='192.168.1.4';  end

  if (ischar(skt)) skt=sktopen(skt); end
  fbw=1/dsr;
  if ((exist('butter')~=3))
   pkg load signal
  end
  [bb,aa]=butter(3,fbw/2);
  sr=1000.0; %sample rate
  sp=1/sr;
  ds_sp=sp*dsr;  %down sample sample rate

sinlength=10000.0/32768.0;
[a,ptr]=GetSensData1(skt,2);
[a,ptr]=GetSensData1(skt,ptr);

  idx=find(a>32767.0);
  msa=max(size(a));
  a(idx)=a(idx)-65536;
  a=a*sinlength;

pos=mean(a)*ones(1,n);
[fpos,sf]=filter(bb,aa,pos);
ppos=[ pos' fpos'];

figure(1);
clf;
snum=1:max(size(pos));
t=(snum-1)'*sp;
numsamps=max(snum);
subplot(211);
phdl=plot(t,ppos);
pahdl=get(phdl(1),'parent');
s=sprintf('mean pos= %2.4fum  rms=%2.4fum',mean(pos),sqrt(var(pos)));
s=[s sprintf('mean pos= %2.4fum  rms=%2.4fum',mean(pos),sqrt(var(pos)))];
ylabel('um');
xlabel('Time (Secs)');
thdl=title(s);
grid on;
drawnow;

ds_pos=(mean(pos)*ones(1,nds));
ds_snum=1:max(size(ds_pos));
ds_t=((ds_snum-1)'*ds_sp)';

subplot(212);
ds_phdl=plot(ds_t,ds_pos);
ds_s=sprintf('mean pos= %2.4fum  rms=%2.4fum',mean(ds_pos),sqrt(var(ds_pos)));
ylabel('um');
xlabel('Time (Secs)');
ds_thdl=title(ds_s);
grid on;
drawnow;
ds_pahdl=get(ds_phdl,'parent');

while (size(kbhit(1))(1)<1)
  [a,ptr]=GetSensData1(skt,ptr);
  msa=size(a)(2);
  if (msa>0)
   idx=find(a>32767.0);
   a(idx)=a(idx)-65536;
   a=a*sinlength;
   [fa,sf]=filter(bb,aa,a,sf);
   pos=[pos((msa+1):end) a];
   msfa=size(fa)(2);
   if(msfa>0)
    fpos=[fpos((msfa+1):end) fa];
    idx=(1:msfa)+numsamps;
    numsamps=numsamps+msfa;
    idx=find(rem(idx,dsr)==0);
    if (min(size(idx))>0)
     ds_a=fa(idx);
     ds_pos=[(ds_pos((size(ds_a)(2)+1):end)) ds_a];
     RESB=udpget(skt,'RESB');
     ds_s=sprintf('mean pos= %2.4fum  rms=%2.4fum   Signal Strength=%5.0f',mean(ds_pos),sqrt(var(ds_pos)),RESB);
     set(ds_thdl,'string',ds_s);
     mindp=min(ds_pos);
     maxdp=max(ds_pos);
     if (mindp>=maxdp)
       maxdp=mindp+1;
     end
     ylim(ds_pahdl,[mindp maxdp]);
     set(ds_phdl,'ydata',ds_pos);
    end
   end
   s=sprintf('un-filtered mean pos= %2.4fum  rms=%2.4fum',mean(pos),sqrt(var(pos)));
   s=[s sprintf('       filtered mean pos= %2.4fum  rms=%2.4fum',mean(fpos),sqrt(var(fpos)))];
   set(thdl,'string',s);
   minp=min(pos);
   maxp=max(pos);
   if (minp>=maxp)
     maxp=minp+1;
   end
   ylim(pahdl,[minp maxp]);
   set(phdl(1),'ydata',pos');
   set(phdl(2),'ydata',fpos');
   drawnow;
   pause(0.1)
  end
end

